#include "typesIIgs.r"

/* Shell Application Resources - v3.0  Copyright 1988-1989 Apple Computer, Inc.
   All shell resources are in the range 0x0000nnnn, the lowest allowable 64K
   range of application resource IDs.  											*/

/* Changes since you last looked: 890821 --JML
   Made rAlertString generic (removed all names to protect the innocent).
   Centered rAlertString within Alert dialog. Added divider beneath "Close"
   item so it would meet Human Interface Guidelines. Changed "File" menu's
   rMenu resource to use ShellResStart + 3 instead of a hard coded resource number.
   Changed file name from Shell.Rez to Shell.r so MPW will automatically find
   the interface files. */
   
/* More changes: 890830 --DGS
   Replaced expanded resource ID calculations with symbolic identifiers, expanded calculations
   for these at top of the file. Revised format of menu resource ID calculation to include multiple
   menu bars. Renamed the identifers for the base and shift values used in the ID calculation. 
   Modified comments below and for resource rMenuBar. Made identifiers of resource IDs for controls 
   and items distinct from the IDs of the controls and items and from the resource ID of the
   corresponding title */

	/* for clarity and ease of distinguishing between IDs of resources and IDs of toolbox entities, 
	   identifiers for resource IDs are suffixed with RID and identifiers for other toolbox entities 
	   such as menu and window controls are suffixed with ID */
	   
#define BaseResID 0x0				/* starting offset for shell resources */
#define MenuBarIDShift 0x1000		/* multiplier for menu numbers in resource IDs */
#define MenuIDShift 0x100			/* multiplier for menu bar numbers in resource IDs */

	/* The menu resource IDs are in the form 0x0000wxyy calculated as 
	   ID = BaseResID + (w*MenuBarIDShift) + (x*MenuIDShift) + yy, 
	   where w  is the menu bar number in the range $1 to $F, x is the number of the menu in the 
	   range $0 to $F and yy is the number of the item number in that menu in the range $01 to $FF.
	   The shell program uses the conventions that:
	   
	   1. the resource id of a menu is that of the zeroth item within it, 
	   
	   2. the resource id of a menu bar is that of the zeroth item in the zeroth menu
	   contained within that menu bar, and 
	   
	   3. values of zero for w and x correspond to the 16th menubar or menu in a menu bar.
	   
	   For example, the 2nd item from the 3rd menu in the 5th menu bar has resource ID 0x00005302 
	   when BaseResID is 0x0, MenuIDShift is 0x100, and MenuBarIDShift is 0x1000. The resource id of 
	   the menu containing this item is that of the zeroth item in the 3rd menu of the 5th menu bar, 
	   0x00005300. The resource id of the menu bar containing this menu and menu item is that of the 
	   zeroth item in the zeroth menu, 0x00005000. 
	   
	   Further conventions used by the shell program are:
	   
	   4. control and item IDs and resource IDs for controls and items are the same and resource IDs 
	   for their title strings are also the same, and 
		  
	   5. since the title string resource IDs are the same as the menu resource IDs, resource IDs
	   for other resources of type rPString are assumed to be of the form 0x0000wnnn where
	   w is any number $0 to $F not assigned to a menu bar; as a suggestion, this value w can be 
	   distinct for each kind of window using resources within the program, if the number of 
	   menu bars plus the number of distinct kinds of resource-using windows is 16 or less.

	   Note that structuring the menu resource IDs in this form 0x0000wxyy avoids a bug in the system
	   version 5.0 of NewMenuBar2 where it cannot release resources unless the high word of the 
	   resource ID is zero. These conventions also allow for easy processing of resource IDs entirely
	   represented in the low word of the ID, for easy editing of menus, menu bars, and menu items,
	   as shown below, and for a reference when debugging. These conventions are suggested for 
	   programming convenience only, programmers may wish to devise other conventions for assigning 
	   resource IDs differently. 
	   
	   For instance:
	   
	   1. programmers may want to utilize the high word of resource IDs,
	   
	   2. programmers may want to consolidate the RID, title RID, and ID identifiers in their 
	   programs if these will always be defined to be the same. 
	   
	   3. pop-up menus could be assigned using a form similar to that used above for menus except 
	   that w would be any number $0 to $F, not assigned to a menu bar, designating a window in which
	   the pop-up was used.
	   
	   4. resource IDs for the other various resource types, in general, may be assigned so that the 
	   low word of the resource ID is of approximate form 0x0000abcc where a is any number $0 to $F, 
	   not assigned to a menu bar, designating a window in which the resource is used, b is any nine
	   bit wide zero value, and cc is a number $0 to $7F distinguishing the resource from others of 
	   the same type used in a particular window. For programs not using suggestion (2) above and 
	   having windows using a large number of resources, the value for b could be a nine bit value 
	   designating the resource type with the high order bit in the least significant position.
	   
	   Again, these are only illustrations of how programmers  may adopt  resource ID conventions 
	   suitable within a particular program.
	   
	   CAUTION: Resource IDs must be distinct within each resource type and must not be > 0x07FEFFFF.
	   
	   */
	   
#define AboutAlertStringRID BaseResID + 1

#define MenuBarOneRID BaseResID + (1 * MenuBarIDShift)

#define AppleMenuRID MenuBarOneRID + (1 * MenuIDShift)
#define FileMenuRID MenuBarOneRID + (2 * MenuIDShift)
#define EditMenuRID MenuBarOneRID + (3 * MenuIDShift)
#define SoundMenuRID MenuBarOneRID + (4 * MenuIDShift)

#define AboutRID AppleMenuRID + 1

#define QuitRID FileMenuRID + 2

#define SoundVersionRID 		SoundMenuRID + 4
#define SoundToolStatusRID 		SoundMenuRID + 6
#define FFGeneratorStatusRID 	SoundMenuRID + 7
#define FFSoundDoneStatusRID 	SoundMenuRID + 8
#define FFSoundStatusRID 		SoundMenuRID + 9
#define FFStartSoundRID 		SoundMenuRID + 10
#define FFStopSoundRID 			SoundMenuRID + 11
#define GetSoundVolumeRID 		SoundMenuRID + 12
#define GetTableAddressRID 		SoundMenuRID + 13
#define ReadRamBlockRID 		SoundMenuRID + 14
#define SetSoundMIRQVRID 		SoundMenuRID + 15
#define SetSoundVolumeRID 		SoundMenuRID + 16
#define SetUserSoundIRQVRID 	SoundMenuRID + 17
#define WriteRamBlockRID 		SoundMenuRID + 18
#define FFSetUpSoundRID 		SoundMenuRID + 19
#define FFStartPlayingRID 		SoundMenuRID + 20
#define SetDOCRegRID 			SoundMenuRID + 21
#define ReadDOCRegRID 			SoundMenuRID + 22
	
	/* The edit menu item IDs are by convention defined with the values below, starting at 250. Since 
   this program uses the same values for the corresponding resource IDs, be careful not to attempt to
   reuse these resource IDs items and title strings in particular */
   
#define UndoRID 250
#define CutRID 251
#define CopyRID 252
#define PasteRID 253
#define ClearRID 254
#define CloseRID 255

#define AppleMenuTitleRID MenuBarOneRID + (1 * MenuIDShift)
#define FileMenuTitleRID MenuBarOneRID + (2 * MenuIDShift)
#define EditMenuTitleRID MenuBarOneRID + (3 * MenuIDShift)
#define SoundMenuTitleRID MenuBarOneRID + (4 * MenuIDShift)

#define AboutTitleRID AppleMenuRID + 1

#define QuitTitleRID FileMenuRID + 2


#define SoundVersionTitleRID 		SoundMenuRID + 4
#define SoundToolStatusTitleRID 	SoundMenuRID + 6
#define FFGeneratorStatusTitleRID 	SoundMenuRID + 7
#define FFSoundDoneStatusTitleRID 	SoundMenuRID + 8
#define FFSoundStatusTitleRID 		SoundMenuRID + 9
#define FFStartSoundTitleRID 		SoundMenuRID + 10
#define FFStopSoundTitleRID 		SoundMenuRID + 11
#define GetSoundVolumeTitleRID 		SoundMenuRID + 12
#define GetTableAddressTitleRID 	SoundMenuRID + 13
#define ReadRamBlockTitleRID 		SoundMenuRID + 14
#define SetSoundMIRQVTitleRID 		SoundMenuRID + 15
#define SetSoundVolumeTitleRID 		SoundMenuRID + 16
#define SetUserSoundIRQVTitleRID 	SoundMenuRID + 17
#define WriteRamBlockTitleRID 		SoundMenuRID + 18
#define FFSetUpSoundTitleRID 		SoundMenuRID + 19
#define FFStartPlayingTitleRID 		SoundMenuRID + 20
#define SetDOCRegTitleRID 			SoundMenuRID + 21
#define ReadDOCRegTitleRID 			SoundMenuRID + 22

#define UndoTitleRID 250
#define CutTitleRID 251
#define CopyTitleRID 252
#define PasteTitleRID 253
#define ClearTitleRID 254
#define CloseTitleRID 255

#define MenuBarOneID BaseResID + (1 * MenuBarIDShift)

#define AppleMenuID MenuBarOneID + (1 * MenuIDShift)
#define FileMenuID MenuBarOneID + (2 * MenuIDShift)
#define EditMenuID MenuBarOneID + (3 * MenuIDShift)
#define SoundMenuID MenuBarOneID + (4 * MenuIDShift)

#define AboutID AppleMenuID + 1

#define QuitID FileMenuID + 2

#define SoundVersionID 			SoundMenuID + 4
#define SoundToolStatusID 		SoundMenuID + 6
#define FFGeneratorStatusID 	SoundMenuID + 7
#define FFSoundDoneStatusID 	SoundMenuID + 8
#define FFSoundStatusID 		SoundMenuID + 9
#define FFStartSoundID 			SoundMenuID + 10
#define FFStopSoundID 			SoundMenuID + 11
#define GetSoundVolumeID 		SoundMenuID + 12
#define GetTableAddressID 		SoundMenuID + 13
#define ReadRamBlockID 			SoundMenuID + 14
#define SetSoundMIRQVID 		SoundMenuID + 15
#define SetSoundVolumeID 		SoundMenuID + 16
#define SetUserSoundIRQVID 		SoundMenuID + 17
#define WriteRamBlockID 		SoundMenuID + 18
#define FFSetUpSoundID 			SoundMenuID + 19
#define FFStartPlayingID 		SoundMenuID + 20
#define SetDOCRegID 			SoundMenuID + 21
#define ReadDOCRegID 			SoundMenuID + 22

#define UndoID 250
#define CutID 251
#define CopyID 252
#define PasteID 253
#define ClearID 254
#define CloseID 255

#define MainToolStartupRID BaseResID+1

resource rAlertString (AboutAlertStringRID)	{
	"7"
	"3/"
	TBCenterJust
	"Apple IIGS Sound Tools Exerciser, Version 3.0"
	TBEndOfLine
	"By Apple II Developer Technical Support"
	TBEndOfLine
	" 1988, 1989 Apple Computer, Inc."
	TBEndOfLine
	"/^#0\000"
};

resource rMenuBar (MenuBarOneRID)	{
	
/*	Note:  The form of this resource ID $0000wxyy where w is the menu bar number avoids a bug in 
		   NewMenuBar2 - it can't release resources unless the high word of the ID is zero.
		   --MD	*/
	   	   
/*	   1.1B1 - Changed the Apple Menu to properly use Color Replace highlighting, to
	   avoid the "Green Apple" when the menu is pulled down.  --MD	*/
	
	{
	AppleMenuRID,										/* Apple menu */
	FileMenuRID,										/* File menu */
	EditMenuRID											/* Edit menu */
	}
};

resource rMenu (AppleMenuRID)	{
	AppleMenuID,										/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
														/* flags */
	AppleMenuTitleRID,									/* Title reference */
	{AboutID}											/* Menu item reference */
};

resource rMenu (FileMenuRID)	{
	FileMenuID,											/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
														/* flags */
	FileMenuTitleRID,									/* Title reference */
	{CloseID,
	QuitID}												/* Menu item references */
};

resource rMenu (EditMenuRID)	{
	EditMenuID,											/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache+rmDisabled,
														/* flags */
	EditMenuTitleRID,									/* Title reference */
	{UndoID,
	CutID,
	CopyID,
	PasteID,
	ClearID} 											/* Menu item references */
};

resource rMenu (SoundMenuRID)	{
	SoundMenuID,										/* Menu ID */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
														/* flags */
	SoundMenuTitleRID,									/* Title reference */
	{SoundVersionID,
	SoundToolStatusID,
	FFGeneratorStatusID,
	FFSoundDoneStatusID,
	FFSoundStatusID,
	FFStartSoundID,
	FFStopSoundID,
	GetSoundVolumeID,
	GetTableAddressID,
	ReadRamBlockID,
	SetSoundMIRQVID,
	SetSoundVolumeID,
	SetUserSoundIRQVID,
	WriteRamBlockID,
	FFSetUpSoundID,
	FFStartPlayingID,
	SetDOCRegID,
	ReadDOCRegID
	} 											/* Menu item references */
};

resource rMenuItem (AboutRID,nocrossbank)	{
	AboutID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider,			/* Item flags */
	AboutTitleRID										/* Title reference */
};

resource rMenuItem (CloseRID,nocrossbank)	{
	CloseID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider+rMIDisabled,
														/* Item flags */
	CloseTitleRID										/* Title reference */
};

resource rMenuItem (QuitRID,nocrossbank)	{
	QuitID,												/* Item ID */
	"Q","q",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	QuitTitleRID										/* Title reference */
};

resource rMenuItem (UndoRID,nocrossbank)	{
	UndoID,												/* Item ID */
	"Z","z",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDivider+rMIDisabled,
														/* Item flags */
	UndoTitleRID										/* Title reference */
};

resource rMenuItem (CutRID,nocrossbank)	{
	CutID,												/* Item ID */
	"X","x",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	CutTitleRID											/* Title reference */
};

resource rMenuItem (CopyRID,nocrossbank)	{
	CopyID,												/* Item ID */
	"C","c",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	CopyTitleRID										/* Title reference */
};

resource rMenuItem (PasteRID,nocrossbank)	{
	PasteID,											/* Item ID */
	"V","v",											/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	PasteTitleRID										/* Title reference */
};

resource rMenuItem (ClearRID,nocrossbank)	{
	ClearID,											/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift+rMIDisabled,		/* Item flags */
	ClearTitleRID										/* Title reference */
};

resource rMenuItem (SoundVersionRID,nocrossbank)	{
	SoundVersionID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SoundVersionTitleRID									/* Title reference */
};

resource rMenuItem (SoundToolStatusRID,nocrossbank)	{
	SoundToolStatusID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SoundToolStatusTitleRID								/* Title reference */
};

resource rMenuItem (FFGeneratorStatusRID,nocrossbank)	{
	FFGeneratorStatusID,								/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFGeneratorStatusTitleRID							/* Title reference */
};

resource rMenuItem (FFSoundDoneStatusRID,nocrossbank)	{
	FFSoundDoneStatusID,								/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFSoundDoneStatusTitleRID							/* Title reference */
};

resource rMenuItem (FFSoundStatusRID,nocrossbank)	{
	FFSoundStatusID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFSoundStatusTitleRID								/* Title reference */
};

resource rMenuItem (FFStartSoundRID,nocrossbank)	{
	FFStartSoundID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFStartSoundTitleRID								/* Title reference */
};

resource rMenuItem (FFStopSoundRID,nocrossbank)	{
	FFStopSoundID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFStopSoundTitleRID									/* Title reference */
};

resource rMenuItem (GetSoundVolumeRID,nocrossbank)	{
	GetSoundVolumeID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	GetSoundVolumeTitleRID								/* Title reference */
};

resource rMenuItem (GetTableAddressRID,nocrossbank)	{
	GetTableAddressID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	GetTableAddressTitleRID								/* Title reference */
};

resource rMenuItem (ReadRamBlockRID,nocrossbank)	{
	ReadRamBlockID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	ReadRamBlockTitleRID								/* Title reference */
};

resource rMenuItem (SetSoundMIRQVRID,nocrossbank)	{
	SetSoundMIRQVID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SetSoundMIRQVTitleRID								/* Title reference */
};

resource rMenuItem (SetSoundVolumeRID,nocrossbank)	{
	SetSoundVolumeID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SetSoundVolumeTitleRID								/* Title reference */
};

resource rMenuItem (SetUserSoundIRQVRID,nocrossbank)	{
	SetUserSoundIRQVID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SetUserSoundIRQVTitleRID							/* Title reference */
};

resource rMenuItem (WriteRamBlockRID,nocrossbank)	{
	WriteRamBlockID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	WriteRamBlockTitleRID								/* Title reference */
};

resource rMenuItem (FFSetUpSoundRID,nocrossbank)	{
	FFSetUpSoundID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFSetUpSoundTitleRID								/* Title reference */
};

resource rMenuItem (FFStartPlayingRID,nocrossbank)	{
	FFStartPlayingID,									/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	FFStartPlayingTitleRID								/* Title reference */
};

resource rMenuItem (SetDOCRegRID,nocrossbank)	{
	SetDOCRegID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	SetDOCRegTitleRID									/* Title reference */
};

resource rMenuItem (ReadDOCRegRID,nocrossbank)	{
	ReadDOCRegID,										/* Item ID */
	"","",												/* Item characters */
	NIL,												/* Item check */
	RefIsResource*ItemTitleRefShift,					/* Item flags */
	ReadDOCRegTitleRID									/* Title reference */
};

	
	/* The following PStrings are our menu titles and IDs.  1.1B1 changes the menu titles
   to use two spaces on either side, as recommended for 640 mode in IIgs TN #5.  --MD   */
   
resource rPString (AppleMenuTitleRID,nocrossbank)	{
	"@"
};

resource rPString (AboutTitleRID,nocrossbank)	{
	"About the Sound Tools Exerciser"
};

resource rPString (FileMenuTitleRID,nocrossbank)	{
	"  File  "
};

resource rPString (CloseTitleRID,nocrossbank)	{
	"Close"
};

resource rPString (QuitTitleRID,nocrossbank)	{
	"Quit"
};

resource rPString (EditMenuTitleRID,nocrossbank)	{
	"  Edit  "
};

resource rPString (UndoTitleRID,nocrossbank)	{
	"Undo"
};

resource rPString (CutTitleRID,nocrossbank)	{
	"Cut"
};

resource rPString (CopyTitleRID,nocrossbank)	{
	"Copy"
};

resource rPString (PasteTitleRID,nocrossbank)	{
	"Paste"
};

resource rPString (ClearTitleRID,nocrossbank)	{
	"Clear"
};

resource rPString (SoundMenuTitleRID,nocrossbank)	{
	"Sound Command:  "
};

resource rPString (SoundVersionTitleRID,nocrossbank)	{
	"SoundVersion"
};

resource rPString (SoundToolStatusTitleRID,nocrossbank)	{
	"SoundToolStatus"
};

resource rPString (FFGeneratorStatusTitleRID,nocrossbank)	{
	"FFGeneratorStatus"
};

resource rPString (FFSoundDoneStatusTitleRID,nocrossbank)	{
	"FFSoundDoneStatus"
};

resource rPString (FFSoundStatusTitleRID,nocrossbank)	{
	"FFSoundStatus"
};

resource rPString (FFStartSoundTitleRID,nocrossbank)	{
	"FFStartSound"
};

resource rPString (FFStopSoundTitleRID,nocrossbank)	{
	"FFStopSound"
};

resource rPString (GetSoundVolumeTitleRID,nocrossbank)	{
	"GetSoundVolume"
};

resource rPString (GetTableAddressTitleRID,nocrossbank)	{
	"GetTableAddress"
};

resource rPString (ReadRamBlockTitleRID,nocrossbank)	{
	"ReadRamBlock"
};
	
resource rPString (SetSoundMIRQVTitleRID,nocrossbank)	{
	"SetSoundMIRQV"
};
	
resource rPString (SetSoundVolumeTitleRID,nocrossbank)	{
	"SetSoundVolume"
};
	
resource rPString (SetUserSoundIRQVTitleRID,nocrossbank)	{
	"SetUserSoundIRQV"
};

resource rPString (WriteRamBlockTitleRID,nocrossbank)	{
	"WriteRamBlock"
};

resource rPString (FFSetUpSoundTitleRID,nocrossbank)	{
	"FFSetUpSound"
};

resource rPString (FFStartPlayingTitleRID,nocrossbank)	{
	"FFStartPlaying"
};

resource rPString (SetDOCRegTitleRID,nocrossbank)	{
	"SetDOCReg"
};

resource rPString (ReadDOCRegTitleRID,nocrossbank)	{
	"ReadDOCReg"
};


resource rToolStartup (MainToolStartupRID,nocrossbank)	{
	
	/* We've expanded this list over the original 1.0 Shell list to include more tools
	   for desk accessories to use, as described in Apple IIgs Technical Note #53,
	   "Desk Accessories and Tools."  The table is also longer because the previous
	   version of the shell didn't load ROM-based tools it started (like QuickDraw).
	   
	   As a suggestion, maintain a complete list of the tools as shown below. This way it is easy to
	   edit tools in and out of the list by inserting or deleting the comment symbols, and it is
	   clear which tools are loaded and which tools are not loaded.
	   
	   The Resource Manager (#30) is automatically taken care of by StartUpTools (or else it couldn't
	   read this resource!) The Tool Locator and Memory Manager are started up seperately, prior to
	   StartUpTools and shut down after ShutDownTools. */
   
	$C080,										/* 640 mode + fastport aware + shadowing */
	{
		3,$0300,	/* misc tools */
		4,$0301,	/* quickdraw */
		5,$0302,	/* desk manager */
		6,$0300,	/* eventMgr */
		7,$0200,	/* scheduler */
		8,$0301,	/* sound tools */
/*		9,$0201,	/* ADB tools */
/*		10,$0202,	/* SANE */
		11,$0200,	/* int math */
/*		12,$0201,	/* Text Tool Set */
		14,$0301,	/* Window Manager */
		15,$0301,	/* Menu Manager */
		16,$0301,	/* Control Manager */
/*		17,$0300,	/* System Loader */
		18,$0301,	/* QD Aux */
		19,$0300,	/* print manager */
		20,$0301,	/* LineEdit tool set */
		21,$0302,	/* Dialog Manager */
		22,$0300,	/* Scrap manager */
		23,$0301,	/* standard file */
/*		25,$0104,	/* NoteSynth */
/*		26,$0104,	/* Note Seq */
		27,$0301,	/* Font manager */
		28,$0301,	/* list manager */
/*		29,$0101,	/* ACE */
/*		32,$0103,	/* Midi Tools */
		34,$0101	/* text edit */
	}
};

/*  Application-specific resources  */


/*------------------- Values used through out -------------------*/

#define MainWindowID		$1000
#define DocRegParamBlkID 	 202
#define oscGenTypeID 		 203
#define freqLow1ID 			 204
#define freqHigh1ID 		 205
#define vol1ID 				 206
#define tablePtr1ID 		 207
#define control1ID 			 208
#define tableSize1ID		 209
#define freqLow2ID 			 210
#define freqHigh2ID 		 211
#define vol2ID 				 212
#define tablePtr2ID 		 213
#define control2ID 			 214
#define tableSize2ID 		 215
#define SoundParamBlockID 	 216
#define waveStartID 		 217
#define waveSizeID 			 218
#define freqOffsetID 		 219
#define docBufferID 		 220
#define bufferSizeID 		 221
#define nextWavePtrID 		 222
#define volSettingID 		 223
#define Parm1ID				 224
#define Parm2ID				 225
#define Parm3ID				 226

#define curfileID			 228
#define loadedAtID			 229
#define buffSizeID		 	 230
#define resultID			 231
#define toolerrID			 232

#define oscGenType	 		 301
#define freqLow1   			 302
#define freqHigh1   		 303
#define vol1   				 304
#define tablePtr1   		 305
#define control1   			 306
#define tableSize1  		 307
#define freqLow2   			 308
#define freqHigh2   		 309
#define vol2   				 310
#define tablePtr2   		 311
#define control2   			 312
#define tableSize2   		 313
#define waveStart   		 314
#define waveSize   			 315
#define freqOffset   		 316
#define docBuffer   		 317
#define bufferSize   		 318
#define nextWavePtr   		 319
#define volSetting   		 320
#define Parm1  				 321
#define Parm2 				 322
#define Parm3 				 323

#define execbut				 350
#define loadbut				 351
#define	sndCmdPopUp			 352

/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the main window with all the buttons that lead
/* to other buttons.
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (MainWindowID) {
	fTitle+fVis,											/* Frame Bits 			*/
	0x201,													/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{30,10,195,630},										/* window Position */
	infront,												/* wPlane */
	MainWindowID,											/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the main window
/*---------------------------------------------------------------------------*/
resource rPString (0x201) {
	"Sound Tools Exerciser"
	};



/* List of all controls in Main Window */

resource rControlList (MainWindowID) {
	{	DocRegParamBlkID,
		oscGenTypeID,
		freqLow1ID,
		freqHigh1ID,
		vol1ID,
		tablePtr1ID,
		control1ID,
		tableSize1ID,
		freqLow2ID,
		freqHigh2ID,
		vol2ID,
		tablePtr2ID,
		control2ID,
		tableSize2ID,
		SoundParamBlockID,
		waveStartID,
		waveSizeID,
		freqOffsetID,
		docBufferID,
		bufferSizeID,
		nextWavePtrID,   
		volSettingID,
		curfileID,
		Parm1ID,
		Parm2ID,
		Parm3ID,
		Parm3,
		Parm2,
		Parm1,
		volSetting,
		nextWavePtr,   
		bufferSize,
		docBuffer,
		freqOffset,
		waveSize,
		waveStart,
		tableSize2,
		control2,
		tablePtr2,
		vol2,
		freqHigh2,
		freqLow2,
		tableSize1,
		control1,
		tablePtr1,
		vol1,
		freqHigh1,
		freqLow1,
 		oscGenType,
		loadedAtID,
		buffSizeID,
		resultID,
		toolerrID,
		loadbut,
		execbut,
		sndCmdPopUp
	};
};

#define butwidth	100
#define butheight	12
#define curfieldwidth 145

#define statwidth	93
#define editwidth	93
#define gap1		3
#define gap2		9

#define stattop 	15
#define statbot		27
#define statdisp	11

#define statleft	2
#define statright	statleft+statwidth

#define editleft	statright+gap1
#define editright	editleft+editwidth

#define statleft2	editright+gap2
#define statright2	statleft2+statwidth

#define editleft2	statright2+gap1
#define editright2	editleft2+editwidth

#define statleft3	editright2+gap2
#define statright3	statleft3+statwidth+10

#define editleft3	statright3+gap1+10
#define editright3	editleft3+editwidth+10



resource rControlTemplate (DocRegParamBlkID)  {
	DocRegParamBlkID,									/* control ID */
	{1,statleft,13,statright+50},							/* control rectangle */
	StatTextControl{{									/* control type */
		0x0001,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		DocRegParamBlkID								/* title ref */
	}};
}; 

resource rControlTemplate (oscGenTypeID)  {
	oscGenTypeID,										/* control ID */
	{stattop,statleft,statbot,statright},				/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		oscGenTypeID									/* title ref */
	}};
}; 

resource rControlTemplate (freqLow1ID)  {
	freqLow1ID,											/* control ID */
	{stattop+(1*statdisp),statleft,
	 statbot+(1*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		freqLow1ID										/* title ref */
	}};
}; 

resource rControlTemplate (freqHigh1ID)  {
	freqHigh1ID,										/* control ID */
	{stattop+(2*statdisp),statleft,
	 statbot+(2*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		freqHigh1ID										/* title ref */
	}};
}; 

resource rControlTemplate (vol1ID)  {
	vol1ID,												/* control ID */
	{stattop+(3*statdisp),statleft,
	 statbot+(3*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		vol1ID											/* title ref */
	}};
}; 

resource rControlTemplate (tablePtr1ID)  {
	tablePtr1ID,										/* control ID */
	{stattop+(4*statdisp),statleft,
	 statbot+(4*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		tablePtr1ID										/* title ref */
	}};
}; 

resource rControlTemplate (control1ID)  {
	control1ID,											/* control ID */
	{stattop+(5*statdisp),statleft,
	 statbot+(5*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		control1ID										/* title ref */
	}};
}; 

resource rControlTemplate (tableSize1ID)  {
	tableSize1ID,										/* control ID */
	{stattop+(6*statdisp),statleft,
	 statbot+(6*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		tableSize1ID										/* title ref */
	}};
}; 

resource rControlTemplate (freqLow2ID)  {
	freqLow2ID,											/* control ID */
	{stattop+(7*statdisp),statleft,
	 statbot+(7*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		freqLow2ID										/* title ref */
	}};
}; 

resource rControlTemplate (freqHigh2ID)  {
	freqHigh2ID,										/* control ID */
	{stattop+(8*statdisp),statleft,
	 statbot+(8*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		freqHigh2ID										/* title ref */
	}};
}; 

resource rControlTemplate (vol2ID)  {
	vol2ID,												/* control ID */
	{stattop+(9*statdisp),statleft,
	 statbot+(9*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		vol2ID											/* title ref */
	}};
}; 

resource rControlTemplate (tablePtr2ID)  {
	tablePtr2ID,										/* control ID */
	{stattop+(10*statdisp),statleft,
	 statbot+(10*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		tablePtr2ID										/* title ref */
	}};
}; 

resource rControlTemplate (control2ID)  {
	control2ID,											/* control ID */
	{stattop+(11*statdisp),statleft,
	 statbot+(11*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		control2ID										/* title ref */
	}};
}; 

resource rControlTemplate (tableSize2ID)  {
	tableSize2ID,										/* control ID */
	{stattop+(12*statdisp),statleft,
	 statbot+(12*statdisp),statright},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		tableSize2ID									/* title ref */
	}};
}; 

resource rControlTemplate (SoundParamBlockID)  {
	SoundParamBlockID,									/* control ID */
	{1,statleft2,13,statright2+50},							/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		SoundParamBlockID								/* title ref */
	}};
}; 

resource rControlTemplate (waveStartID)  {
	waveStartID,										/* control ID */
	{stattop+(0*statdisp),statleft2,
	 statbot+(0*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		waveStartID										/* title ref */
	}};
}; 

resource rControlTemplate (waveSizeID)  {
	waveSizeID,										/* control ID */
	{stattop+(1*statdisp),statleft2,
	 statbot+(1*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		waveSizeID										/* title ref */
	}};
}; 

resource rControlTemplate (freqOffsetID)  {
	freqOffsetID,										/* control ID */
	{stattop+(2*statdisp),statleft2,
	 statbot+(2*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		freqOffsetID										/* title ref */
	}};
}; 

resource rControlTemplate (docBufferID)  {
	docBufferID,										/* control ID */
	{stattop+(3*statdisp),statleft2,
	 statbot+(3*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		docBufferID										/* title ref */
	}};
}; 

resource rControlTemplate (bufferSizeID)  {
	bufferSizeID,										/* control ID */
	{stattop+(4*statdisp),statleft2,
	 statbot+(4*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		bufferSizeID										/* title ref */
	}};
}; 

resource rControlTemplate (nextWavePtrID)  {
	nextWavePtrID,										/* control ID */
	{stattop+(5*statdisp),statleft2,
	 statbot+(5*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		nextWavePtrID										/* title ref */
	}};
}; 

resource rControlTemplate (volSettingID)  {
	volSettingID,										/* control ID */
	{stattop+(6*statdisp),statleft2,
	 statbot+(6*statdisp),statright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF00,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		volSettingID										/* title ref */
	}};
}; 

resource rControlTemplate (Parm1ID)  {
	Parm1ID,										/* control ID */
	{stattop+(0*statdisp),statleft3,
	 statbot+(0*statdisp),statright3},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		Parm1ID										/* title ref */
	}};
}; 

resource rControlTemplate (Parm2ID)  {
	Parm2ID,										/* control ID */
	{stattop+((1*statdisp)+2),statleft3,
	 statbot+((1*statdisp)+2),statright3},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		Parm2ID										/* title ref */
	}};
}; 

resource rControlTemplate (Parm3ID)  {
	Parm3ID,										/* control ID */
	{stattop+((2*statdisp)+4),statleft3,
	 statbot+((2*statdisp)+4),statright3},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		Parm3ID										/* title ref */
	}};
}; 

resource rControlTemplate (curfileID)  {
	curfileID,										/* control ID */
	{stattop+(11*statdisp),statleft2,
	 statbot+(11*statdisp),statleft3+50},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		curfileID										/* title ref */
	}};
}; 

resource rControlTemplate (loadedAtID)  {
	loadedAtID,										/* control ID */
	{stattop+(12*statdisp),statleft2,
	 statbot+(12*statdisp),editright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		loadedAtID										/* title ref */
	}};
}; 

resource rControlTemplate (buffSizeID)  {
	buffSizeID,										/* control ID */
	{stattop+(12*statdisp),statleft3,
	 statbot+(12*statdisp),editright3},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		buffSizeID										/* title ref */
	}};
}; 

resource rControlTemplate (resultID)  {
	resultID,										/* control ID */
	{stattop+(9*statdisp),statleft2,
	 statbot+(9*statdisp),editright2},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		resultID										/* title ref */
	}};
}; 

resource rControlTemplate (toolerrID)  {
	toolerrID,										/* control ID */
	{stattop+(9*statdisp),statleft3,
	 statbot+(9*statdisp),editright3},					/* control rectangle */
	StatTextControl{{									/* control type */
		0xFF03,											/* flag */
		0x1002,											/* more flags */
		0,												/* ref con */
		toolerrID										/* title ref */
	}};
}; 

resource rTextForLETextBox2 (DocRegParamBlkID) {
		"DocRegParamBlk"
};

resource rTextForLETextBox2 (oscGenTypeID) {
		"oscGenType"
};

resource rTextForLETextBox2 (freqLow1ID) {
		"freqLow1"
};

resource rTextForLETextBox2 (freqHigh1ID) {
		"freqHigh1"
};

resource rTextForLETextBox2 (vol1ID) {
		"vol1"
};

resource rTextForLETextBox2 (tablePtr1ID) {
		"tablePtr1"
};

resource rTextForLETextBox2 (control1ID) {
		"control1"
};

resource rTextForLETextBox2 (tableSize1ID) {
		"tableSize1"
};

resource rTextForLETextBox2 (freqLow2ID) {
		"freqLow2"
};

resource rTextForLETextBox2 (freqHigh2ID) {
		"freqHigh2"
};

resource rTextForLETextBox2 (vol2ID) {
		"vol2"
};

resource rTextForLETextBox2 (tablePtr2ID) {
		"tablePtr2"
};

resource rTextForLETextBox2 (control2ID) {
		"control2"
};

resource rTextForLETextBox2 (tableSize2ID) {
		"tableSize2"
};

resource rTextForLETextBox2 (SoundParamBlockID) {
		"SoundParamBlock"
};

resource rTextForLETextBox2 (waveStartID) {
		"waveStart"
};

resource rTextForLETextBox2 (waveSizeID) {
		"waveSize"
};

resource rTextForLETextBox2 (freqOffsetID) {
		"freqOffset"
};

resource rTextForLETextBox2 (docBufferID) {
		"docBuffer"
};

resource rTextForLETextBox2 (bufferSizeID) {
		"bufferSize"
};

resource rTextForLETextBox2 (nextWavePtrID) {
		"nextWavePtr"
};

resource rTextForLETextBox2 (volSettingID) {
		"volSetting"
};

resource rTextForLETextBox2 (Parm1ID) {
		"*6"
};

resource rTextForLETextBox2 (Parm2ID) {
		"*7"
};

resource rTextForLETextBox2 (Parm3ID) {
		"*8"
};

resource rTextForLETextBox2 (curfileID) {
		"Current File: *1"
};

resource rTextForLETextBox2 (loadedAtID) {
		"Loaded At:   $*2"
};

resource rTextForLETextBox2 (buffSizeID) {
		"Buffer Size: $*3"
};

resource rTextForLETextBox2 (resultID) {
		"Result:      $*4"
};

resource rTextForLETextBox2 (toolerrID) {
		"_ToolErr:    $*5"
};

/* Text Edit Controls*/

resource rControlTemplate (oscGenType)  {
	oscGenType,																/* control ID */
	{stattop+(0*statdisp),editleft,
	 statbot+(0*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		oscGenType													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (freqLow1)  {
	freqLow1,																/* control ID */
	{stattop+(1*statdisp),editleft,
	 statbot+(1*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		freqLow1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (freqHigh1)  {
	freqHigh1,																/* control ID */
	{stattop+(2*statdisp),editleft,
	 statbot+(2*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		freqHigh1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (vol1)  {
	vol1,																/* control ID */
	{stattop+(3*statdisp),editleft,
	 statbot+(3*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		vol1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (tablePtr1)  {
	tablePtr1,																/* control ID */
	{stattop+(4*statdisp),editleft,
	 statbot+(4*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		tablePtr1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (control1)  {
	control1,																/* control ID */
	{stattop+(5*statdisp),editleft,
	 statbot+(5*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		control1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (tableSize1)  {
	tableSize1,																/* control ID */
	{stattop+(6*statdisp),editleft,
	 statbot+(6*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		tableSize1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (freqLow2)  {
	freqLow2,																/* control ID */
	{stattop+(7*statdisp),editleft,
	 statbot+(7*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		freqLow2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (freqHigh2)  {
	freqHigh2,																/* control ID */
	{stattop+(8*statdisp),editleft,
	 statbot+(8*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		freqHigh2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (vol2)  {
	vol2,																/* control ID */
	{stattop+(9*statdisp),editleft,
	 statbot+(9*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		vol2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (tablePtr2)  {
	tablePtr2,																/* control ID */
	{stattop+(10*statdisp),editleft,
	 statbot+(10*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		tablePtr2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (control2)  {
	control2,																/* control ID */
	{stattop+(11*statdisp),editleft,
	 statbot+(11*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		control2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (tableSize2)  {
	tableSize2,																/* control ID */
	{stattop+(12*statdisp),editleft,
	 statbot+(12*statdisp),editright},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		tableSize2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (waveStart)  {
	waveStart,																/* control ID */
	{stattop+(0*statdisp),editleft2,
	 statbot+(0*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		waveStart													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (waveSize)  {
	waveSize,																/* control ID */
	{stattop+(1*statdisp),editleft2,
	 statbot+(1*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		waveSize													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (freqOffset)  {
	freqOffset,																/* control ID */
	{stattop+(2*statdisp),editleft2,
	 statbot+(2*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		freqOffset													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (docBuffer)  {
	docBuffer,																/* control ID */
	{stattop+(3*statdisp),editleft2,
	 statbot+(3*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		docBuffer													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (bufferSize)  {
	bufferSize,																/* control ID */
	{stattop+(4*statdisp),editleft2,
	 statbot+(4*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		bufferSize													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (nextWavePtr)  {
	nextWavePtr,																/* control ID */
	{stattop+(5*statdisp),editleft2,
	 statbot+(5*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		nextWavePtr													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (volSetting)  {
	volSetting,																/* control ID */
	{stattop+(6*statdisp),editleft2,
	 statbot+(6*statdisp),editright2},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		volSetting													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (Parm1)  {
	Parm1,																/* control ID */
	{stattop+(0*statdisp),editleft3,
	 statbot+(0*statdisp),editright3},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		Parm1													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (Parm2)  {
	Parm2,																/* control ID */
	{stattop+((1*statdisp)+2),editleft3,
	 statbot+((1*statdisp)+2),editright3},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		Parm2													/* Initial Value Ref */
	}};
}; 

resource rControlTemplate (Parm3)  {
	Parm3,																/* control ID */
	{stattop+((2*statdisp)+4),editleft3,
	 statbot+((2*statdisp)+4),editright3},					/* control rectangle */
	EditLineControl{{												/* control type */
		0,															/* Flag */
		fctlProcNotPtr+RefIsResource,								/* More Flags */
		0,															/* ref con */
		40,															/* Max Length */
		Parm3													/* Initial Value Ref */
	}};
}; 

resource rPString (oscGenType) {
	"0000"
	};

resource rPString (freqLow1) {
	"00"
	};

resource rPString (freqHigh1) {
	"00"
	};

resource rPString (vol1) {
	"00"
	};

resource rPString (tablePtr1) {
	"00"
	};

resource rPString (control1) {
	"00"
	};

resource rPString (tableSize1) {
	"00"
	};

resource rPString (freqLow2) {
	"00"
	};

resource rPString (freqHigh2) {
	"00"
	};

resource rPString (vol2) {
	"00"
	};

resource rPString (tablePtr2) {
	"00"
	};

resource rPString (control2) {
	"00"
	};

resource rPString (tableSize2) {
	"00"
	};

resource rPString (waveStart) {
	"00000000"
	};

resource rPString (waveSize) {
	"0000"
	};

resource rPString (freqOffset) {
	"0000"
	};

resource rPString (docBuffer) {
	"0000"
	};

resource rPString (bufferSize) {
	"0000"
	};

resource rPString (nextWavePtr) {
	"00000000"
	};

resource rPString (volSetting) {
	"0000"
	};

resource rPString (Parm1) {
	"00000000"
	};

resource rPString (Parm2) {
	"00000000"
	};

resource rPString (Parm3) {
	"00000000"
	};

resource rControlTemplate (execbut)  {
	execbut,												/* control ID */
	{stattop+(8*statdisp)-2,editleft3,
	 stattop+(8*statdisp)-2+butheight,editleft3+butwidth},	/* control rect */
	SimpleButtonControl{{									/* button type */
		0,													/* flag */
		0x1002,												/* more flags */
		0,													/* ref con */
		execbut												/* title ref */
	}};
}; 
resource rPString (execbut) {
	"Execute"
	};

resource rControlTemplate (loadbut)  {
	loadbut,												/* control ID */
	{stattop+(11*statdisp)-2,editleft3,
	 stattop+(11*statdisp)-2+butheight,editleft3+butwidth},	/* control rect */
	SimpleButtonControl{{									/* button type */
		0,													/* flag */
		0x1002,												/* more flags */
		0,													/* ref con */
		loadbut												/* title ref */
	}};
}; 
resource rPString (loadbut) {
	"Load"
	};

resource rControlTemplate (sndCmdPopUp) {
	sndCmdPopUp,										/* control ID */
	{stattop+((8*statdisp)-3),statleft2,
	 statbot+((8*statdisp)-3),statleft3+80},			/* control rectangle */
	PopUpControl{{										/* control type */
		fInWindowOnly,									/* flags */
		FctlProcNotPtr+RefIsResource,					/* MoreFlags */
		0,												/* RefCon */
		0,												/* Title Width */
		SoundMenuRID,									/* Menu ref */
		SoundVersionRID									/* Initial Value */
	}}
};
